using System;
using System.Collections.Generic;

using System.Data;
using VIRP.CRS.BO;
using VIRP.CRS.DAL;
using VIRP.EFR.BO;
using System.Linq;

namespace VIRP.CRS.BLL
{
	public static partial class WKF_CASE_ACTIVITYManager
	{
        #region Fields
        #endregion

        #region Constructors
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static WKF_CASE_ACTIVITY GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            WKF_CASE_ACTIVITY objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            return objReturn;
        }

        public static List<WKF_CASE_ACTIVITY> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objSave)
        {
            Int32 objReturn = 0;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Int32 SaveFromReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objSave)
        {
            Int32 objReturn = 0;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.SaveFromReferral(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Int32 SaveAll(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, List<WKF_CASE_ACTIVITY> objSave)
        {
            Int32 objReturn = 0;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.SaveAll(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            Boolean objReturn = false;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.WKF_CASE_ACTIVITY_ID);
        }

        public static WKF_CASE_ACTIVITY SelectByActivityType(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID, string ACTIVITY_TYPE)
        {
            WKF_CASE_ACTIVITY objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            WorkFlowActivityTypes type = (WorkFlowActivityTypes)Enum.Parse(typeof(WorkFlowActivityTypes), ACTIVITY_TYPE);

            var types = objDB.GetitemsByWorkflowCaseId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);

            objReturn = types.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(type)).FirstOrDefault();

            return objReturn;
        }

        public static List<WKF_CASE_ACTIVITY> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetItemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<KitOrders> GetOrderedKitOrders(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<KitOrders> objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetOrderedKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<LabResult> GetNewLabResults(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int STD_WKFACTIVITYSTS_ID)
        {
            List<LabResult> objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetNewLabResults(CURRENT_USER, CURRENT_REGISTRY_ID, STD_WKFACTIVITYSTS_ID);

            return objReturn;
        }

        public static List<WKF_CASE_ACTIVITY> GetItemsByWorkstream(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetItemsByWorkstream(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);

            return objReturn;
        }

        public static List<WKF_CASE_ACTIVITY> GetitemsByWorkflowCaseId(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetitemsByWorkflowCaseId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);

            return objReturn;
        }

        public static List<LabOrderByStatus> GetItemsByStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_WKFACTIVITYSTS_ID)
        {
            List<LabOrderByStatus> objReturn = null;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.GetItemsByStatus(CURRENT_USER, CURRENT_REGISTRY_ID, STD_WKFACTIVITYSTS_ID);

            return objReturn;
        }

        public static Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID, Int32 STD_WKFACTIVITYSTS_ID)
        {
            Boolean objReturn = false;
            WKF_CASE_ACTIVITYDB objDB = new WKF_CASE_ACTIVITYDB();

            objReturn = objDB.UpdateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID, STD_WKFACTIVITYSTS_ID);

            return objReturn;
        }

		#endregion
	}
}
